/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.effects;

import org.eclipse.swt.*;

public class CompositeEffect extends Effect {
	
	public CompositeEffect() {
		super();
	}
	
	void createHandle() {
		object = new Effect[0];
		if (object == null) SWT.error(SWT.ERROR_NO_HANDLES);
	}
	
	public void addEffect(Effect effect) {
		checkEffect();
		int len = ((Effect[])object).length;
		Effect[] newEffects = new Effect[len + 1];
		System.arraycopy(object, 0, newEffects, 0, len);
		newEffects[len] = effect;
		object = newEffects;
	}
	
	public void removeEffect(Effect effect) {
		checkEffect();
		Effect[] effects = (Effect[])object;
		for (int i = 0; i < effects.length; i++) {
			if (effects[i] == effect) {
				System.arraycopy(object, i + 1, object, i, effects.length - i - 1);
				Effect[] newEffects = new Effect[effects.length - 1];
				System.arraycopy(object, 0, newEffects, 0, newEffects.length);
				object = newEffects;
				break;
			}
		}
	}
}
